package jamezo97.clonecraft.dna;

import jamezo97.clonecraft.entity.EntityModifiable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntitySquid;

public class GeneMarine extends Gene{

	public GeneMarine(int id) {
		super(id);
	}

	@Override
	public String getName() {
		return "Marine";
	}

	@Override
	public int getMaxAmount() {
		return 1;
	}

	@Override
	public String getStringValue(int amount) {
		return "Marine";
	}

	@Override
	public int getColour() {
		return 0xff53f2ba;
	}

	@Override
	public Class[] getEntityClassesWithGene() {
		return new Class[]{EntitySquid.class};
	}

	@Override
	public void onUpdate(EntityLivingBase entity, IModifiable mod, int level) {
		if(entity.getAir() < 300){
			entity.setAir(300);
		}
	}

	@Override
	public void addGeneEffect(EntityLivingBase entity, int level) {
	}

}
